$(function() {

	var urlvars = getUrlVars();
	var reviewId = parseInt(urlvars['revid'], 10);
	var requestId = parseInt(urlvars['rid'], 10);
	var userId = parseInt(urlvars['userId'], 10);
	var workflowId = parseInt(urlvars['wid'], 10);
	
	$('textarea#inputMessage').focus();

	
	$('div.modal-footer').on('click', 'button#submit', function(e) {
		
		//require a message
		var denyMessage = $('textarea#inputMessage').val();
		if( denyMessage == null || denyMessage === "" ) {
			alert("Please enter a message describing the reason for denying this request.");
		} else {
		
			var aiMap;
			var ajaxUrl;
			if (reviewId !== 0) {
				aiMap = {"reviewId":reviewId};
				ajaxUrl = '../../dart/rejectReview.json';
			} else {
				aiMap = {"requestId":requestId};
				ajaxUrl = '../../dart/rejectRequest.json';
			}
			
			
			
			aiMap['userId'] = userId;
			aiMap['text'] = $('textarea#inputMessage').val();
			aiMap['workflowId'] = workflowId; 
			
			// actually, I want this to be synchronous
			$.ajax({
				url:ajaxUrl,
				type:'POST',
				async:false,
				contentType:'application/json',
				dataType:'json',
				data:JSON.stringify(aiMap),
				success:function(data,textStatus,three) {
					if (textStatus === 'success') {
						window.opener.location.href="../dashboard.html";
						
						window.close();
					}
				}
			});
		}
	});
});
	

getUrlVars = function()
{
	var vars = [], hash;
	var hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');
	for(var i = 0; i < hashes.length; i++)
	{
	    hash = hashes[i].split('=');
	    vars.push(hash[0]);
	    vars[hash[0]] = hash[1];
	}
	return vars;
}